/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

public final class IKTokenizer
extends Tokenizer {
    private IKSegmenter _IKImplement;
    private final CharTermAttribute termAtt;
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt;
    private int endPosition;
    private int skippedPositions;
    private PositionIncrementAttribute posIncrAtt;

    public IKTokenizer(Configuration configuration) {
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this._IKImplement = new IKSegmenter(this.input, configuration);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        Lexeme nextLexeme = this._IKImplement.next();
        if (nextLexeme != null) {
            this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
            this.termAtt.append(nextLexeme.getLexemeText());
            this.termAtt.setLength(nextLexeme.getLength());
            this.offsetAtt.setOffset(this.correctOffset(nextLexeme.getBeginPosition()), this.correctOffset(nextLexeme.getEndPosition()));
            this.endPosition = nextLexeme.getEndPosition();
            this.typeAtt.setType(nextLexeme.getLexemeTypeString());
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this._IKImplement.reset(this.input);
        this.skippedPositions = 0;
        this.endPosition = 0;
    }

    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.endPosition + this._IKImplement.getLastUselessCharNum());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }
}

